﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>

<script runat="server">

    public enum Grupowanie {
        wgWydziału, wgPracownika
    }
    
    public class Params: ContextBase {
        public Params(Context context): base(context) {
            Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
            miesiąc = new YearMonth(data);
        }

        YearMonth miesiąc;
        [Required]
        [Priority(10)]
        public YearMonth Miesiąc {
            get { return miesiąc; }
            set {
                miesiąc = value;
                OnChanged(EventArgs.Empty);
            }
        }    

        Wydzial[] definicja;
        [Caption("Wydziały")]
        [Priority(20)]
        public Wydzial[] Definicja {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        Grupowanie grupa = Grupowanie.wgWydziału;
        [Caption("Grupuj")]
        [Priority(30)]
        public Grupowanie Grupa {
            get { return grupa; }
            set {
                grupa = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicja() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.Wydzialy.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }                    
    }

    Params pars = null;
    [Context(Required = true)]
    public Params Param {
        set {
            definicja = value.Definicja;
            pars = value;
        }
    }

    Wydzial[] definicja;
    
    void OnContextLoad(Object sender, EventArgs args) {
        object[] lst = { "(wszystkie)" };
        ReportHeader["WYDZIAL"] = Info("Wydział", "Wydziały", (definicja == null) ? lst : definicja);
        ReportHeader["OKRES"] = pars.Miesiąc.ToString();

        if (pars.Grupa == Grupowanie.wgWydziału) {
            colWydzial.Visible = false;
            colPracownik.Visible = true;
            Grid1.GroupData0 = "Workers.Info.Historia.Etat.Wydzial";
            Grid1.Sort = "Workers.Info.Historia.Etat.Wydzial.Nazwa,Pracownik";
        }
        else {
            colWydzial.Visible = true;
            colPracownik.Visible = false;
            Grid1.GroupData0 = "Pracownik";
            Grid1.Sort = "Pracownik,Workers.Info.Historia.Etat.Wydzial.Nazwa";
        }
    }    
    
    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik idx = (Pracownik)args.Row;
        SubTable st = idx.Module.Dodatki.WgPracownik[idx];
        
        PracHistoria ph = idx[pars.Miesiąc.LastDay];
        if (definicja != null && definicja.Length > 0) {
            ArrayList list = new ArrayList(definicja);
            if (!list.Contains(ph.Etat.Wydzial)) {
                args.VisibleRow = false;
                return;
            }
        }

        bool any = false;
        colPracownik.AddLine(idx);
        foreach (Dodatek dt in st) {
            DodHistoria dh = dt[pars.Miesiąc.LastDay];
            if (dh == null)
                continue;           
            if ((dh.Okres.From > pars.Miesiąc.LastDay) ||
                (dh.Okres.To.ToYearMonth() < pars.Miesiąc))
                continue;           
            colNazwa.AddLine(dh.Dodatek.Nazwa);
            if (!dh.Element.Algorytm.Potracenie) {
                colDodatek.AddLine(dh.Podstawa.Value);
                colPotracenie.AddLine(new decimal(0));
            }
            else {
                colDodatek.AddLine(new decimal(0));
                colPotracenie.AddLine(dh.Podstawa.Value);
            }
            if (dh.Element.Algorytm.DodWspolczynnik.Length > 0)
                colUlamek.AddLine(dh.Wspolczynnik.ToString());
            else
                colUlamek.AddLine(dh.Ulamek.ToString());
            colProcent.AddLine(dh.Procent);
            colCzas.AddLine(dh.Czas);
            colDni.AddLine(dh.Dni);
            any = true;
        }

        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, lst[0]);
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = obj.ToString();
            else
                info += "</strong>, <strong>" + obj.ToString();
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }
        
</script>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Dodatki i potrącenia</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad" Landscape="true"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Miesięczne zestawienie dodatków i potrąceń|</strong><strong>%WYDZIAL%|</strong>Za okres:<strong> %OKRES%"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Kadry.Dodatek,Soneta.KadryPlace" onbeforerow="Grid_BeforeRow"
                GroupLine="{0}" ShowGroupSum="True">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" ID="colWydzial" DataMember="Workers.Info.Historia.Etat.Wydzial" Caption="Wydział" Width="25"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" ID="colPracownik" Caption="Pracownik" Width="60"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" ID="colNazwa" Caption="Nazwa" VAlign="Top" Total="Info"></ea:GridColumn>					
                    <ea:GridColumn runat="server" Align="Right" ID="colDodatek" Caption="Dodatek" Width="12" HideZero="true" VAlign="Top" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Right" ID="colPotracenie" Caption="Potrącenie" Width="12" HideZero="true" VAlign="Top" Total="Sum"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="colUlamek" Caption="Współczynnik" Width="14" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="colProcent" Caption="Procent" Width="10" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="colCzas" Caption="Czas" Width="8" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="colDni" Caption="Dni" Width="5" VAlign="Top"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

